function [b,BNmag,cell_lifter,stitle,c]=cepstral_liftering_speech(xin,ss,win,fs,L,nfft,cepl,ccal,fname)
%
% Program to show the effect of different duration cepstral lifters on
% resulting log magnitude spectrum of a frame of speech
%
% Program uses conventional signal processing to compute
% the complex and real cepstrum of a speech signal; then it uses
% lifters with various cutoff quefrencies to smooth the spectrum
% and plot the smoothed spectrum over the original spectrum
%
% Inputs:
%   xin: speech array
%   ss: starting sample in speech file
%   win: window coefficients of L sample window
%   fs: sampling rate of speech
%   L: frame (window) duration in samples
%   nfft: size of fft for cepstral computations
%   cepl: length of complex or real cepstrum (samples)
%   ccal: choice of complex (1) or real (2) cepstrum
%   fname: speech filename
%
% Outputs:
%   b: windowed speech frame
%   BNmag: original log magnitude of signal
%   cell_lifter: cell array of low quefrency liftered log magnitude
%   stitle: title for plots
%   c: real cepstrum for frame of speech

% create windowed frame of speech
    b=zeros(1,nfft);
    b(1:L)=xin(ss:ss+L-1).*win;

% form cepstrum using fundamental dsp processing
% first wrap b so that the delay is approximately 0
    bw=[b(L/2+1:L) zeros(1,nfft-L) b(1:L/2)];
    
% compute spectrum, phase, unwrapped phase, compute complex cepstrum using
% regular matlab code;
    BN=fft(bw,nfft);
    phase_rad=angle(BN);
    phase_rad_unwrap=unwrap(phase_rad);
    BNmag_ph=log(abs(BN))+phase_rad_unwrap*i;
    BNmag=real(BNmag_ph);
    xhat=ifft(BNmag_ph,nfft);
    xhats=[xhat(nfft-cepl+1:nfft) xhat(1:cepl+1)];
    xhats=real(xhats);
        
% form real cepstrum if ccal = 2
    if (ccal == 2) c=(xhats+fliplr(xhats))/2;
    end
    
    if (ccal == 1)
        s1=sprintf('complex cepstrum liftering -- file:%s,',fname);
        s2=sprintf(' ss:%d lifter:20,40,60,80,100',ss);
    else
        s1=sprintf('real cepstrum liftering -- file:%s,',fname);
        s2=sprintf(' ss:%d lifter:20,40,60,80,100',ss);
    end
        stitle=strcat(s1,s2);
        
% low quefrency lifter for lifter length=20, 40, 60, 80 and 100 quefrencies
    for lifterl=20:20:100
        index=lifterl/20;
        lifter(1:nfft)=0;
        lifter(1:lifterl+1)=1;
        lifter(nfft-lifterl+1:nfft)=1;
      
% case - complex cepstrum computed using basic dsp methods
        xhatl=real(xhat.*lifter);
        BNmagn=real(fft(xhatl,nfft));
        cell_lifter{index}=BNmagn;
    end
    
% zero out c(cepl) for gain control
    c(cepl)=0;
end

